DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
	`products_id` int(11) NOT NULL AUTO_INCREMENT,
	`products_ean` varchar(128) DEFAULT NULL,
	`products_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`products_shippingtime` int(4) NOT NULL DEFAULT '0',
	`products_model` varchar(64) DEFAULT NULL,
	`group_permission_0` tinyint(1) NOT NULL DEFAULT '0',
	`group_permission_1` tinyint(1) NOT NULL DEFAULT '0',
	`group_permission_2` tinyint(1) NOT NULL DEFAULT '0',
	`group_permission_3` tinyint(1) NOT NULL DEFAULT '0',
	`products_sort` int(4) NOT NULL DEFAULT '0',
	`products_image` varchar(255) DEFAULT NULL,
	`products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`products_discount_allowed` decimal(5,2) NOT NULL DEFAULT '0.00',
	`products_date_added` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
	`products_last_modified` timestamp NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	`products_date_available` datetime DEFAULT NULL,
	`products_weight` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`products_status` tinyint(1) NOT NULL DEFAULT '0',
	`products_tax_class_id` int(11) NOT NULL DEFAULT '0',
	`product_template` varchar(64) DEFAULT NULL,
	`options_template` varchar(64) DEFAULT NULL,
	`manufacturers_id` int(11) DEFAULT NULL,
	`products_ordered` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`products_fsk18` int(1) NOT NULL DEFAULT '0',
	`products_vpe` int(11) NOT NULL DEFAULT '0',
	`products_vpe_status` int(1) NOT NULL DEFAULT '0',
	`products_vpe_value` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`products_startpage` int(1) NOT NULL DEFAULT '0',
	`products_startpage_sort` int(4) NOT NULL DEFAULT '0',
	`group_ids` varchar(5) NOT NULL DEFAULT '',
	`nc_ultra_shipping_costs` decimal(15,4) NOT NULL DEFAULT '0.0000',
	`gm_show_date_added` int(1) unsigned NOT NULL DEFAULT '0',
	`gm_show_price_offer` int(1) unsigned NOT NULL DEFAULT '0',
	`gm_show_weight` int(1) NOT NULL DEFAULT '0',
	`gm_price_status` int(10) unsigned NOT NULL DEFAULT '0',
	`gm_min_order` decimal(15,4) NOT NULL DEFAULT '1.0000',
	`gm_graduated_qty` decimal(15,4) NOT NULL DEFAULT '1.0000',
	`gm_options_template` varchar(64) DEFAULT NULL,
	`gm_priority` varchar(3) NOT NULL DEFAULT '0.5',
	`gm_changefreq` varchar(255) NOT NULL DEFAULT 'weekly',
	`gm_show_qty_info` int(1) unsigned NOT NULL DEFAULT '0',
	`gm_sitemap_entry` int(1) NOT NULL DEFAULT '1',
	`products_image_w` int(11) NOT NULL DEFAULT '0',
	`products_image_h` int(11) NOT NULL DEFAULT '0',
	`gm_show_image` int(1) unsigned NOT NULL DEFAULT '1',
	`properties_dropdown_mode` varchar(30) NOT NULL DEFAULT '',
	`properties_show_price` varchar(10) NOT NULL DEFAULT '',
	`use_properties_combis_weight` tinyint(1) NOT NULL DEFAULT '0',
	`use_properties_combis_quantity` tinyint(1) NOT NULL DEFAULT '0',
	`use_properties_combis_shipping_time` tinyint(1) NOT NULL DEFAULT '0',
	`product_type` tinyint(1) NOT NULL DEFAULT '1',
	`main_category_id` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`products_id`),
	KEY `idx_products_date_added` (`products_date_added`),
	KEY `products_id` (`products_id`,`products_status`,`products_date_added`),
	KEY `products_status` (`products_status`,`products_id`,`products_date_added`),
	KEY `products_status_2` (`products_status`,`products_id`,`products_price`),
	KEY `products_status_3` (`products_status`,`products_ordered`,`products_id`),
	KEY `products_status_4` (`products_status`,`products_model`,`products_id`),
	KEY `products_status_products_startpage` (`products_status`,`products_startpage`),
	KEY `products_id_2` (`products_id`,`products_startpage`,`products_status`,`products_startpage_sort`),
	KEY `products_date_available` (`products_date_available`,`products_id`),
	KEY `products_quantity` (`products_quantity`),
	KEY `products_sort` (`products_sort`),
	KEY `products_tax_class_id` (`products_tax_class_id`),
	KEY `manufacturers_id` (`manufacturers_id`),
	KEY `products_model` (`products_model`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;

INSERT INTO `products` (`products_id`, `products_ean`, `products_quantity`, `products_shippingtime`, `products_model`, `group_permission_0`, `group_permission_1`, `group_permission_2`, `group_permission_3`, `products_sort`, `products_image`, `products_price`, `products_discount_allowed`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `product_template`, `options_template`, `manufacturers_id`, `products_ordered`, `products_fsk18`, `products_vpe`, `products_vpe_status`, `products_vpe_value`, `products_startpage`, `products_startpage_sort`, `group_ids`, `nc_ultra_shipping_costs`, `gm_show_date_added`, `gm_show_price_offer`, `gm_show_weight`, `gm_price_status`, `gm_min_order`, `gm_graduated_qty`, `gm_options_template`, `gm_priority`, `gm_changefreq`, `gm_show_qty_info`, `gm_sitemap_entry`, `products_image_w`, `products_image_h`, `gm_show_image`, `properties_dropdown_mode`, `properties_show_price`, `use_properties_combis_weight`, `use_properties_combis_quantity`, `use_properties_combis_shipping_time`, `product_type`, `main_category_id`)
VALUES
(1, '', 998.0000, 1, 'ABC123', 0, 0, 0, 0, 0, 'combined.png', 16.7983, 0.00, '2008-08-08 17:19:46', '2020-03-06 14:15:20', '1000-01-01 00:00:00', 0.0000, 1, 1, 'standard.html', 'product_options_dropdown.html', 0, 1.0000, 0, 0, 0, 0.0000, 1, 1, '', 0.0000, 0, 1, 0, 0, 1.0000, 1.0000, 'product_options_dropdown.html', '0.5', 'daily', 1, 1, 130, 130, 1, 'dropdown_mode_1', 'true', 0, 0, 1, 1, 0),
(2, '', 998.0000, 1, 'DEF456', 0, 0, 0, 0, 0, 'manual.jpg', 0, 0.00, '2021-11-10 14:44:30', '2021-11-10 14:44:30', '1000-01-01 00:00:00', 0.0000, 1, 1, 'standard.html', 'product_options_dropdown.html', 0, 1.0000, 0, 0, 0, 0.0000, 1, 1, '', 0.0000, 0, 1, 0, 0, 1.0000, 1.0000, 'product_options_dropdown.html', '0.5', 'daily', 1, 1, 130, 130, 1, 'dropdown_mode_1', 'true', 0, 0, 1, 1, 0),
(3, '', 998.0000, 1, 'HIJ789', 0, 0, 0, 0, 0, 'sneaker-swag-combined.jpg', 25.2017, 0.00, '2021-11-10 14:44:30', '2021-11-10 14:44:30', '1000-01-01 00:00:00', 0.0000, 1, 1, 'standard.html', 'product_options_dropdown.html', 0, 1.0000, 0, 0, 0, 0.0000, 1, 1, '', 0.0000, 0, 1, 0, 0, 1.0000, 1.0000, 'product_options_dropdown.html', '0.5', 'daily', 1, 1, 130, 130, 1, 'dropdown_mode_1', 'true', 0, 0, 1, 1, 0),
(4, '', 998.0000, 1, 'ABC789', 0, 0, 0, 0, 0, 'laptop.jpg', 2499.99, 2499.99, '2021-11-10 14:44:30', '2021-11-10 14:44:30', '1000-01-01 00:00:00', 0.0000, 1, 1, 'standard.html', 'product_options_dropdown.html', 0, 1.0000, 0, 0, 0, 0.0000, 1, 1, '', 0.0000, 0, 1, 0, 0, 1.0000, 1.0000, 'product_options_dropdown.html', '0.5', 'daily', 1, 1, 130, 130, 1, 'dropdown_mode_1', 'true', 0, 0, 1, 1, 0),
(5, '', 998.0000, 1, 'DEF123', 0, 0, 0, 0, 0, 't-shirt-gambio.jpg', 16.7983, 16.7983, '2021-11-10 14:44:30', '2021-11-10 14:44:30', '1000-01-01 00:00:00', 0.0000, 1, 1, 'standard.html', 'product_options_dropdown.html', 0, 1.0000, 0, 0, 0, 0.0000, 1, 1, '', 0.0000, 0, 1, 0, 0, 1.0000, 1.0000, 'product_options_dropdown.html', '0.5', 'daily', 1, 1, 130, 130, 1, 'dropdown_mode_1', 'true', 0, 0, 1, 1, 0);